using System;
using System.Text;
using System.Globalization;
using System.Diagnostics;
using System.IO;
using System.Collections;
using System.Collections.Specialized;
using System.Reflection;
using System.Collections.Generic;

namespace CSharpRecipes
{
    class MainTester
    {

        #region "(1) KOD TESTOWY ROZDZIAU 1 - lICZBY I TYPY WYLICZENIOWE"
        static void TestNumbersAndEnums()
        {
            PrintHeader("Testy do rozdziau powiconego liczbom");
            Console.WriteLine(((float)1 / 3));						// .3333333
            Console.WriteLine(((float)1 / 3 == (float)0.33333));		// False
            Console.WriteLine(((float)1 / 3 == (float).3333333));		// True
            Console.WriteLine("double.Epsilon: " + double.Epsilon);
            Console.WriteLine("float.Epsilon: " + float.Epsilon);
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo(1, 7, .1428571428571428));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo(1, 7, .14285714285714285));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo(1, 7, .142857 /*1428571428*/, .0000001));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo(1, 7, .14, .01));
            Console.WriteLine();
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).3));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).33));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).3333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).33333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double)0.3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).3333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).33333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).333333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).3333333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).33333333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).3333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).33333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).3333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).33333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333334));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333334));
            Console.WriteLine();
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, .333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, .3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (float)3, .333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (float)3, .3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (double)3, .333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (double)3, .3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (float)3, .333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (float)3, .3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((int)1, (int)3, .333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((int)1, (int)3, .3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((byte)1, (byte)3, .333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((byte)1, (byte)3, .3333333333333333));
            Console.WriteLine();
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (double).3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (float)3, (double).333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (float)3, (double).3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (double)3, (double).333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (double)3, (double).3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (float)3, (double).333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (float)3, (double).3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((int)1, (int)3, (double).333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((int)1, (int)3, (double).3333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((byte)1, (byte)3, (double).333333333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((byte)1, (byte)3, (double).3333333333333333));
            Console.WriteLine();
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (float).333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (double)3, (float).3333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (float)3, (float).333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (float)3, (float).3333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (double)3, (float).333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((float)1, (double)3, (float).3333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (float)3, (float).333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((double)1, (float)3, (float).3333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((int)1, (int)3, (float).333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((int)1, (int)3, (float).3333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((byte)1, (byte)3, (float).333333333));
            Console.WriteLine(NumbersEnums.IsApproximatelyEqualTo((byte)1, (byte)3, (float).3333333333));
            Console.WriteLine();


            Console.WriteLine(NumbersEnums.ConvertDegreesToRadians(0));
            Console.WriteLine(NumbersEnums.ConvertDegreesToRadians(90));
            Console.WriteLine(NumbersEnums.ConvertDegreesToRadians(180));
            Console.WriteLine(NumbersEnums.ConvertDegreesToRadians(270));
            Console.WriteLine(NumbersEnums.ConvertDegreesToRadians(360));
            Console.WriteLine(NumbersEnums.ConvertDegreesToRadians(12));

            Console.WriteLine(NumbersEnums.ConvertRadiansToDegrees(1.5707963267949));
            Console.WriteLine(NumbersEnums.ConvertRadiansToDegrees(3.14159265358979));
            Console.WriteLine(NumbersEnums.ConvertRadiansToDegrees(4.71238898038469));
            Console.WriteLine(NumbersEnums.ConvertRadiansToDegrees(6.28318530717959));
            Console.WriteLine(NumbersEnums.ConvertRadiansToDegrees(5));
            Console.WriteLine(NumbersEnums.ConvertRadiansToDegrees(6));
            Console.WriteLine();


            NumbersEnums.TestBitwiseOp();
            Console.WriteLine();


            Console.WriteLine(NumbersEnums.IsEven(-2));
            Console.WriteLine(NumbersEnums.IsEven(-1));
            Console.WriteLine(NumbersEnums.IsEven(0));
            Console.WriteLine(NumbersEnums.IsEven(1));
            Console.WriteLine(NumbersEnums.IsEven(2));
            Console.WriteLine(NumbersEnums.IsEven(int.MaxValue));
            Console.WriteLine();
            Console.WriteLine(NumbersEnums.IsOdd(-2));
            Console.WriteLine(NumbersEnums.IsOdd(-1));
            Console.WriteLine(NumbersEnums.IsOdd(0));
            Console.WriteLine(NumbersEnums.IsOdd(1));
            Console.WriteLine(NumbersEnums.IsOdd(2));
            Console.WriteLine(NumbersEnums.IsOdd(int.MaxValue));
            Console.WriteLine();

            NumbersEnums.TestSignificance();
            Console.WriteLine();

            NumbersEnums.TestBase10();
            Console.WriteLine();


            NumbersEnums.TestDetermineIfStrIsNum();
            Console.WriteLine();


            NumbersEnums.TestRound();
            Console.WriteLine();


            Console.WriteLine(NumbersEnums.CtoF(0));
            Console.WriteLine(NumbersEnums.CtoF(40));
            Console.WriteLine(NumbersEnums.CtoF(50));
            Console.WriteLine(NumbersEnums.CtoF(-50));
            Console.WriteLine();
            Console.WriteLine(NumbersEnums.FtoC(0));
            Console.WriteLine(NumbersEnums.FtoC(40));
            Console.WriteLine(NumbersEnums.FtoC(50));
            Console.WriteLine(NumbersEnums.FtoC(-50));
            Console.WriteLine();

            NumbersEnums.TestNarrowing();
            Console.WriteLine();


            NumbersEnums.TestTriangle();
            Console.WriteLine();

            NumbersEnums.TestAnglesRightTriangle();
            Console.WriteLine();

            PrintHeader("Enumerations Chapter Tests");
            NumbersEnums.TestDisplayEnumValue();
            NumbersEnums.TestConvertingEnums();
            NumbersEnums.HandleFlagsEnum(Language.All);
            NumbersEnums.HandleFlagsEnum(Language.CSharp);
            NumbersEnums.HandleFlagsEnum(Language.Other);
            NumbersEnums.HandleFlagsEnum(Language.VB6);
            NumbersEnums.HandleFlagsEnum(Language.VBNET);
            NumbersEnums.HandleFlagsEnum((Language)100);
            NumbersEnums.HandleFlagsEnum(1);
            NumbersEnums.HandleFlagsEnum(100);
            NumbersEnums.HandleFlagsEnum(8);
            NumbersEnums.HandleFlagsEnum(3);

            NumbersEnums.TestEnumFlags();

            NumbersEnums.TestTruncate();
        }
        #endregion
        
        #region "(2) KOD TESTOWY ROZDZIAU 2 - ZNAKI I CIGI ZNAKW"
        enum Colors
        {
            red, green, blue
        }

        static void TestStringsAndChars()
        {
            PrintHeader("String and Character Chapter Tests");
			Console.WriteLine(StringsAndChars.GetCharKindInString("abcdef", 4));
			Console.WriteLine(StringsAndChars.GetCharKind('f'));
			Console.WriteLine(StringsAndChars.GetCharKind('0'));
			Console.WriteLine(StringsAndChars.GetCharKind('.'));
			Console.WriteLine(StringsAndChars.GetCharKind('}'));

			Console.WriteLine(StringsAndChars.IsInRange('c', 'a', 'G'));
			Console.WriteLine(StringsAndChars.IsInRange('c', 'a', 'g'));
			Console.WriteLine(StringsAndChars.IsInRange('c', 'c', 'g'));
			Console.WriteLine(StringsAndChars.IsInRange((char)32, 'a', 'b'));
			Console.WriteLine(StringsAndChars.IsInRangeCaseInsensitive('c', 'a', 'G'));
			Console.WriteLine(StringsAndChars.IsInRangeCaseInsensitive('c', 'a', 'c'));
			Console.WriteLine(StringsAndChars.IsInRangeCaseInsensitive('c', 'g', 'g'));
			Console.WriteLine(StringsAndChars.IsInRangeCaseInsensitive((char)32, 'a', 'b'));
			Console.WriteLine(StringsAndChars.IsInRangeExclusive('c', 'c', 'g'));
			Console.WriteLine(StringsAndChars.IsInRangeExclusive('c', 'c', 'g'));
			Console.WriteLine(StringsAndChars.IsInRangeExclusive((char)32, (char)31, 'Z'));
			Console.WriteLine(StringsAndChars.IsInRangeExclusiveCaseInsensitive('c', 'c', 'g'));
			Console.WriteLine(StringsAndChars.IsInRangeExclusiveCaseInsensitive('c', 'c', 'g'));
			Console.WriteLine(StringsAndChars.IsInRangeExclusiveCaseInsensitive((char)32, (char)31, 'Z'));

			Console.WriteLine(StringsAndChars.IsCharEqual('a', 'a'));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', 'b'));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', 'A'));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', 'b', false));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', 'B', false));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', 'A', false));

			Console.WriteLine(StringsAndChars.IsCharEqual('a', CultureInfo.CurrentCulture, 'a', CultureInfo.InvariantCulture));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', CultureInfo.CurrentCulture, 'b', CultureInfo.InvariantCulture));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', CultureInfo.CurrentCulture, 'A', CultureInfo.CurrentCulture));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', CultureInfo.CurrentCulture, 'b', CultureInfo.CurrentCulture, false));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', CultureInfo.CurrentCulture, 'B', CultureInfo.CurrentCulture, false));
			Console.WriteLine(StringsAndChars.IsCharEqual('a', CultureInfo.CurrentCulture, 'A', CultureInfo.CurrentCulture, false));

			foreach (int Position in StringsAndChars.FindAllOccurrences(' ', ""))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', ""))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY"))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", 0))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", 1))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", 3))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", 10))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences(' ', "", true))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "", true))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", true))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", 0, true))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", 1, true))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", 2, true))
				Console.WriteLine(Position.ToString());
			foreach (int Position in StringsAndChars.FindAllOccurrences('a', "have a nice DAY", 10, true))
				Console.WriteLine(Position.ToString());

			foreach (int i in StringsAndChars.FindAll('a', "asdf", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAll('d', "asdf", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAll('g', "asdf", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAll('a', "asdf", 1))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAll("Red", "BlueTealRedredGreenRedYellow", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAll("Blue", "BlueTealRedredGreenRedYellow", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAll("Redd", "BlueTealRedredGreenRedYellow", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAll("Red", "BlueTealRedredGreenRedYellow", 10))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny("a", "asdf", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny(new char[1] { 'a' }, "asdf", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny("d", "asdf", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny("g", "asdf", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny(new char[1] { 'a' }, "asdf", 1))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny("Red", "BlueTealRedredGreenRedYellow", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny(new char[3] { 'R', 'e', 'd' }, "BlueTealRedredGreenRedYellow", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny("Blue", "BlueTealRedredGreenRedYellow", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny("Redd", "BlueTealRedredGreenRedYellow", 0))
				Console.WriteLine(i);
			Console.WriteLine();
			foreach (int i in StringsAndChars.FindAny("Red", "BlueTealRedredGreenRedYellow", 10))
				Console.WriteLine(i);
			Console.WriteLine();

			StringsAndChars.SimpleTokenizer();

			StringsAndChars.TestCompareCaseControl();

			StringsAndChars.StringBeginEndComparisons();

			StringsAndChars.StringInsert();

			StringsAndChars.RemoveReplaceChars();

			string SourceString = "The Inserted Text is here -><-";
			SourceString = SourceString.Insert(28, "Insert-This");
			Console.WriteLine(SourceString);
			SourceString = "The Inserted Text is here -><-";
			char InsertChar = '1';
			SourceString = SourceString.Insert(28, Convert.ToString(InsertChar));
			Console.WriteLine(SourceString);
			StringBuilder SourceStringSB = new StringBuilder("The Inserted Text is here -><-");
			SourceStringSB.Insert(28, "Insert-This");
			Console.WriteLine(SourceStringSB);
			char CharToInsert = '1';
			SourceStringSB = new StringBuilder("The Inserted Text is here -><-");
			SourceStringSB.Insert(28, CharToInsert);
			Console.WriteLine(SourceStringSB);


			Console.WriteLine(StringsAndChars.Base64EncodeBytes(new byte[5] { 32, 33, 34, 35, 36 }));
			foreach (byte b in StringsAndChars.Base64DecodeString(StringsAndChars.Base64EncodeBytes(new byte[5] { 32, 33, 34, 35, 36 })))
				Console.WriteLine(b);

                        try
                        {
    			    FileStream fstrm = new FileStream(@"C:\WINDOWS\winnt.bmp", FileMode.Open, FileAccess.Read);
			    BinaryReader reader = new BinaryReader(fstrm);
			    byte[] image = new byte[reader.BaseStream.Length];
			    for (int i = 0; i < reader.BaseStream.Length; i++)
			    {
			    	image[i] = reader.ReadByte();
			    }
		 	    reader.Close();
			    fstrm.Close();
			    string output = StringsAndChars.Base64EncodeBytes(image);
			    Console.WriteLine(output);

			    byte[] imageBytes = StringsAndChars.Base64DecodeString(output);
			    fstrm = new FileStream(@"C:\winnt.bmp", FileMode.CreateNew, FileAccess.Write);
			    BinaryWriter writer = new BinaryWriter(fstrm);
			    writer.Write(imageBytes);
			    writer.Close();
			    fstrm.Close();

			    File.Delete(@"C:\winnt.bmp");  // Remove this line to actually see the file
                       }
                       catch (System.IO.DirectoryNotFoundException dnfe)
                       {
                            Console.WriteLine(dnfe.ToString());
                       }

			byte[] SourceArray = {128, 83, 111, 117, 114, 99, 101, 
			                         32, 83, 116, 114, 105, 110, 103, 128};
			Console.WriteLine(StringsAndChars.FromASCIIByteArray(SourceArray));
			byte[] SourceArray2 = {128, 0, 83, 0, 111, 0, 117, 0, 114, 0, 99, 0, 
			                          101, 0, 32, 0, 83, 0, 116, 0, 114, 0, 105, 0, 110, 0, 103, 0, 128, 0};
			Console.WriteLine(StringsAndChars.FromUnicodeByteArray(SourceArray2));

			string SourceStr = "Source String";
			foreach (byte b in StringsAndChars.ToASCIIByteArray(SourceStr))
				Console.WriteLine(b);
			foreach (byte b in StringsAndChars.ToUnicodeByteArray(SourceStr))
				Console.WriteLine(b);

			float InitialValue = 0;
			int FinalValue = 0;
			InitialValue = (float)13.499;
			FinalValue = (int)InitialValue;
			Console.WriteLine(FinalValue.ToString());
			InitialValue = (float)13.5;
			FinalValue = (int)InitialValue;
			Console.WriteLine(FinalValue.ToString());
			InitialValue = (float)13.501;
			FinalValue = (int)InitialValue;
			Console.WriteLine(FinalValue.ToString());
			FinalValue = Convert.ToInt32((float)13.449);
			Console.WriteLine(FinalValue.ToString());
			FinalValue = Convert.ToInt32((float)13.5);
			Console.WriteLine(FinalValue.ToString());
			FinalValue = Convert.ToInt32((float)13.501);
			Console.WriteLine(FinalValue.ToString());

			string LongString = "7654321";
			Console.WriteLine(Int32.Parse(LongString));    // LongString = 7654321
			string DblString = "-7654.321";
			Console.WriteLine(Double.Parse(DblString, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign));    // LongString = "-7654.321
			string BoolString = "true";
			Console.WriteLine(Boolean.Parse(BoolString));    // ActualBool = true
			string CharString = "t";
			Console.WriteLine(char.Parse(CharString));    // ActualChar = 't'
			string ColorString = "blue";
			Console.WriteLine((Colors)Colors.Parse(typeof(Colors), ColorString));	// ActualEnum = blue

			int ID = 12345;
			double Weight = 12.3558;
			char Row = 'Z';
			string Section = "1A2C";
			string Output = string.Format(@"The item ID = {0:G} having weight = {1:G} is found in row {2:G} and section {3:G}", ID, Weight, Row, Section);
			Console.WriteLine(Output);
			Output = string.Format(@"The item ID = {0:N} having weight = {1:E} is found in row {2:E} and section {3:E}", ID, Weight, Row, Section);
			Console.WriteLine(Output);
			Output = string.Format(@"The item ID = {0:N} having weight = {1:N} is found in row {2:E} and section {3:D}", ID, Weight, Row, Section);
			Console.WriteLine(Output);
			Output = string.Format(@"The item ID = {0:(#####)} having weight = {1:0000.00 lbs} is found in row {2} and section {3}", ID, Weight, Row, Section);
			Console.WriteLine(Output);
			Console.WriteLine(@"The item ID = {0,5:G} having weight = {1,10:G} is found in row {2,-5:G} and section {3,-10:G}", ID, Weight, Row, Section);

			string[] InfoArray = new string[5] { "11", "12", "Checking", "111", "Savings" };
			Console.WriteLine(string.Join(",", InfoArray));
			InfoArray = new string[4] { "11", "12", "Checking", "Savings" };
			string DelimitedInfoBegin = string.Join(",", InfoArray, 0, 2);
			string DelimitedInfoEnd = string.Join(",", InfoArray, 2, 2);
			string[] DelimitedInfoTotal = new string[2] {DelimitedInfoBegin, 
			                                                DelimitedInfoEnd};
			string DelimitedInfoFinal = string.Join(":", DelimitedInfoTotal);
			Console.WriteLine(DelimitedInfoFinal);

			string DelimitedInfo = "100,200,400,3,67";
			string[] DiscreteInfo = DelimitedInfo.Split(new char[1] { ',' });

			foreach (string Data in DiscreteInfo)
				Console.WriteLine(Data);

			System.Text.StringBuilder sbMax = new System.Text.StringBuilder(10, 10);
			sbMax.Append("123456789");
			sbMax.Append("0");
			try
			{
				sbMax.Append("#");
			}
			catch (ArgumentOutOfRangeException aoore)
			{
				Console.WriteLine(aoore.ToString());
			}

			char[] ca = new char[4] { '1', 'A', '2', 'C' };
			StringsAndChars.InternedStrCls.CreateInternedStr(ca);
			string test = new String(ca);
			if (String.IsInterned(test) == null)
				Console.WriteLine("1 NULL");

			StringBuilder sb = new StringBuilder().Append("AString foo").Append(" is being created");
			StringsAndChars.InternedStrCls.CreateInternedStr(sb);
			string test1 = sb.ToString();
			if (String.IsInterned(test1) == null)
				Console.WriteLine("2 NULL");

			string str = new String('Z', 10);
			StringsAndChars.InternedStrCls.CreateInternedStr(str);
			string test2 = str;
			if (String.IsInterned(test2) == null)
				Console.WriteLine("3 NULL");

			string[] strArray = new String[2] { sb.Append(12).ToString(), sb.Append(13).ToString() };
			StringsAndChars.InternedStrCls.CreateInternedStr(strArray);
			string test3 = strArray[1];
			if (String.IsInterned(test3) == null)
				Console.WriteLine("4 NULL");

			string s11 = "f";
			string s22 = "oo";
			string s33 = s11 + s22;
			StringsAndChars.InternedStrCls.CreateInternedStr(s33);
			string test5 = s33;
			if (String.IsInterned(test5) == null)
				Console.WriteLine("5 NULL");

			string Equation = "1 + 2 - 4 * 5";
			string[] EquationTokens = Equation.Split(new char[1] { ' ' });
			foreach (string Tok in EquationTokens)
				Console.WriteLine(Tok);

			string FullName1 = "John Doe";
			string FullName2 = "Doe,John";
			string FullName3 = "John Q. Doe";
			string[] NameTokens1 = FullName1.Split(new char[3] { ' ', ',', '.' });
			string[] NameTokens2 = FullName2.Split(new char[3] { ' ', ',', '.' });
			string[] NameTokens3 = FullName3.Split(new char[3] { ' ', ',', '.' });
			foreach (string Tok in NameTokens1)
				Console.WriteLine(Tok);
			Console.WriteLine("");
			foreach (string Tok in NameTokens2)
				Console.WriteLine(Tok);
			Console.WriteLine("");
			foreach (string Tok in NameTokens3)
				Console.WriteLine(Tok);

			StringsAndChars.PruningChars();
			string Foo = "--TEST--";
			Console.WriteLine(Foo.Trim(new char[1] { '-' }));
			Foo = ",-TE-,ST-,-";
			Console.WriteLine(Foo.Trim(new char[2] { '-', ',' }));
			Foo = " --TEST-- ";
			Console.WriteLine(Foo.Trim(new char[2] { '-', ' ' }));
			Foo = "TEST";
			Console.WriteLine(Foo.Trim(new char[1] { '-' }));
			Foo = "--TEST--";
			Console.WriteLine(Foo.TrimStart(new char[1] { '-' }));
			Foo = ",-TEST-,-";
			Console.WriteLine(Foo.TrimStart(new char[2] { '-', ',' }));
			Foo = " --TEST-- ";
			Console.WriteLine(Foo.TrimStart(new char[2] { '-', ' ' }));
			Foo = "--TEST--";
			Console.WriteLine(Foo.TrimEnd(new char[1] { '-' }));
			Foo = ",-TEST-,-";
			Console.WriteLine(Foo.TrimEnd(new char[2] { '-', ',' }));
			Foo = " --TEST-- ";
			Console.WriteLine(Foo.TrimEnd(new char[2] { '-', ' ' }));

			StringsAndChars.TestStringForNullEmpty();

			StringsAndChars.AppendLine();

			StringsAndChars.ConvertBlocksOfData();
        }
        #endregion
        
        #region "(3) CLASS & STRUCT CHAPTER TEST CODE"
        static void TestClassesAndStructs()
        {
            PrintHeader("Classes and Structures Chapter Tests");
			ClassAndStructs.TestUnions();
			ClassAndStructs.TestLineToString();
			ClassAndStructs.TestParse();
			ClassAndStructs.TestMediaABC();
			ClassAndStructs.TestSort();
			ClassAndStructs.TestSearch();
			ClassAndStructs.TestObjState();
			ClassAndStructs.ConvertObj(new ClassAndStructs.Base());
			ClassAndStructs.ConvertObj(new ClassAndStructs.Specific());
			ClassAndStructs.TestIPrintInterface();
			ClassAndStructs.SortAllObjects(new ClassAndStructs.IMySort[3] { new ClassAndStructs.CharContainer(), new ClassAndStructs.NumberContainer(), new ClassAndStructs.ObjectContainer() });
			ClassAndStructs.MultiCallBackThroughIFace();
			ClassAndStructs.TestLog();
			ClassAndStructs.TestCloning();
			//ClassAndStructs.TestObjCache();
			ClassAndStructs.TestStaticClasses();
			ClassAndStructs.TestSerializationFacade();
			ClassAndStructs.TestMemento1();
			ClassAndStructs.TestMemento2();
        }
        #endregion

        #region "(4) GENERICS CHAPTER TEST CODE"
        static void TestGenerics()
        {
            //Generics.TestGenericClassInstanceCounter();
            Generics.TestGetGenTypeOf();
            Generics.UseGenericStack();
            Generics.UseNonGenericStack();
            Generics.UseGenericQueue();
            Generics.UseNonGenericQueue();
            Generics.UseNonGenericArrayList();
            Generics.UseGenericList();
            Generics.TestAdapterVsCtor();
            Generics.TestCloneVsGetRange();
            Generics.TestGenericRepeat();
            Generics.CloneGenericList();
            Generics.CloneQueue();
            Generics.CloneStack();
            Generics.UseNonGenericHashtable();
            Generics.MakeCollectionReadOnly();
            Generics.UseGenericDictionary();
            Generics.CloneGenericDictionary();
            Generics.CopyToGenericDictionary();
            Generics.ShowForeachWithDictionary();
            Generics.ShowSettingFieldsToDefaults();
            Generics.UseLinkedList();
            Generics.TestNullableStruct();
            Generics.TestDisposableListCls();
            Generics.TestComparableListCls();
            Generics.TestConversionCls();
            Generics.TestReversibleSortedList();
		}
        #endregion

		#region "(5) COLLECTIONS CHAPTER TEST CODE"
		static void TestCollections()
		{
			PrintHeader("Collections Chapter Tests");
			    Collections.TestSwapArrayElements();
			Collections.TestArrayReversal();
			Collections.TestReverse2DimArray();
			Collections.TestReverseJaggedArray();
			Collections.TestStackTraceArray();
			Collections.TestArrayListEx();
			//Collections.TestArrayListEx2();
			//Collections.TestArrayInsertRemove();
			//Collections.TestSortedList();
			Collections.TestSortKeyValues();
			Collections.TestMaxMinSizeDict();
			Collections.TestMaxMinValueHash();
			Collections.TestDisplayDataAsDelStr();
			Collections.TestListSnapshot();
			Collections.TestSerialization();
			Collections.TestArrayForNulls();
			Collections.TestArrayForEach();
			Collections.TestReadOnlyArray();
		}
		#endregion

		#region "(6) ITERATORS AND PARTIAL CLASSES CHAPTER TEST CODE"
		static void TestIteratorsPartialClasses()
		{
			IteratorsAndPartialTypes.CreateNestedObjects();
			IteratorsAndPartialTypes.TestIterators();
			IteratorsAndPartialTypes.TestShoppingCart();
			IteratorsAndPartialTypes.TestNGShoppingCart();
			IteratorsAndPartialTypes.TestIteratorMethod();
			IteratorsAndPartialTypes.TestIteratorProperties();
			IteratorsAndPartialTypes.TestYieldBreak();
			IteratorsAndPartialTypes.TestOperatorIterator();
			IteratorsAndPartialTypes.TestYieldBreak();
			IteratorsAndPartialTypes.TestFinallyAndIterators();
		}
		#endregion

		#region "(7) EXCEPTION HANDLING CHAPTER TEST CODE"
        static void TestExceptionHandling()
        {
            PrintHeader("Exception Handling Chapter Tests");
            try
            {
                ExceptionHandling.TestParams(1, '1', Language.VB6);
            }
            catch (System.ComponentModel.InvalidEnumArgumentException e)
            {
                Console.WriteLine(e);
            }
            ExceptionHandling.CatchThrownException();
            ExceptionHandling.PreventLossOfException();
            ExceptionHandling.ReflectionException();
            ExceptionHandling.LoadMissingDLL();

            // Uncomment this to see the effects of an uncaught
            // exception and how you can at least be notified
            // before the application terminates...
            //ExceptionHandling.SetupLastChanceSEH();
            try
            {
                ExceptionHandling.TestDisplayException();
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
            ExceptionHandling.TestSpecializedException();
            Console.WriteLine(ExceptionHandling.GetStackTraceInfo(System.Environment.StackTrace));
            Console.WriteLine(ExceptionHandling.GetStackTraceDepth(System.Environment.StackTrace));
            ExceptionHandling.TestTypeInitFailure();
            try
            {
                ExceptionHandling.TestPollingAsyncDelegate();
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
            ExceptionHandling.TestPollingAsyncDelegate();
            ExceptionHandling.TestExceptionData();
        }
        #endregion

        #region "(8) DIAGNOSTICS CHAPTER TEST CODE"
        static void TestDiagnostics()
        {
            PrintHeader("Diagnostics Chapter Tests");
            Diagnostics.SetCustomLogMaxSize("AppLog", 1024000);
            Diagnostics.ExamineConfigFile();
            Diagnostics.EnableTracing();
            Diagnostics.TestMySwitchClass();
            Diagnostics.ProcessRespondingState state;
            foreach (Process P in Process.GetProcesses())
            {
                state = Diagnostics.IsProcessResponding(P);
                if (state == Diagnostics.ProcessRespondingState.NotResponding)
                {
                    Console.WriteLine("{0} is not responding.", P.ProcessName);
                }
            }
            Diagnostics.TestEventLogClass();
            Diagnostics.FindAnEntryInEventLog();
            Diagnostics.FindAnEntryInEventLog2();
            Diagnostics.WatchForAppEvent((EventLog.GetEventLogs())[0]);
            Diagnostics.FindSourceNamesFromLog("Application");
            Diagnostics.FindSourceNamesFromAllLogs();
            Diagnostics.TestCreateSimpleCounter();
            Diagnostics.TestCreateComplexCounter();
            Diagnostics.TestTraceFactoryClass();
            Diagnostics.TestCaptureOutput();
            Diagnostics.TestCustomDebuggerDisplay();
            Diagnostics.ReadAppDomainSettings();
            Diagnostics.TestEnvironment();
            Diagnostics.TestBoostPriority();
        }
        #endregion
        		
        #region "(9) DELEGATES, EVENTS, ANONYMOUS METHODS CHAPTER TEST CODE"
        static void TestDelegatesEventsAnonMeth()
        {
			PrintHeader("Delegates, Events, Anonymous Methods Chapter Tests");
            DelegatesEventsAnonymousMethods.InvokeInReverse();
            DelegatesEventsAnonymousMethods.InvokeEveryOtherSetup();
            DelegatesEventsAnonymousMethods.InvokeWithTest();
            DelegatesEventsAnonymousMethods.TestIndividualInvokesRetVal();
            DelegatesEventsAnonymousMethods.TestIndividualInvokesExceptions();
            DelegatesEventsAnonymousMethods.TestSimpleSyncDelegate();
            DelegatesEventsAnonymousMethods.TestSimpleAsyncDelegate();
            DelegatesEventsAnonymousMethods.TestComplexSyncDelegate();
            DelegatesEventsAnonymousMethods.TestCallbackAsyncDelegate();
            DelegatesEventsAnonymousMethods.TestDirectoryInfoObserver();
            DelegatesEventsAnonymousMethods.FindSpecificInterfaces();

            DelegatesEventsAnonymousMethods DEAM = new DelegatesEventsAnonymousMethods();
            DEAM.TestSearchMembers();

            DelegatesEventsAnonymousMethods.TestObserverPattern();
            DelegatesEventsAnonymousMethods.TestUsingAnonymousMethods();
            DelegatesEventsAnonymousMethods.TestParameterModifiers();
            DelegatesEventsAnonymousMethods.TestClosure();
            DelegatesEventsAnonymousMethods.TestFunctors();
			
        }
        #endregion
        
        #region "(10) REGULAR EXPRESSIONS CHAPTER TEST CODE"
        static void TestRegularExpressions()
        {
			PrintHeader("Regular Expressions Chapter Tests");
			RegEx.TestFindSubstrings();
			RegEx.TestExtractGroupings();
			RegEx.TestUserInputRegEx("");
			RegEx.TestUserInputRegEx(@"");
			RegEx.TestUserInputRegEx("foo");
			RegEx.TestUserInputRegEx(@"\\\");
			RegEx.TestUserInputRegEx(@"\\\\");
			RegEx.TestFindLast();
			RegEx.TestReplace();
			RegEx.TestComplexReplace();
			RegEx.TestTokenize();
			RegEx.TestRegExCompilation();
			RegEx.CreateRegExDLL("REGEX_Test");
			RegEx.UseRegExDLL();
			RegEx.TestLineCount();
			RegEx.TestGetLine();
			RegEx.RegExComments();
			RegEx.TestOccurrencesOf();
			RegEx.TestASPNETParsing();
			RegEx.ExamineBuiltInASPNETParsingRegEx();
        }
        #endregion
        
        #region "(11) DATA STRUCTS AND ALGORITHMS CHAPTER TEST CODE"
        static void TestDataStructsAndAlgorithms()
        {
            PrintHeader("Data Structures and Algorithm Chapter Tests");
			DataStructsAndAlgorithms.CreateHashCodeDataType();
			DataStructsAndAlgorithms.CreatePriorityQueue();
			DataStructsAndAlgorithms.CreatingAMoreVersatileQueue();
			DataStructsAndAlgorithms.DeterminingWhereCharStringNoBalance();
			DataStructsAndAlgorithms.TestMultiMap();
			DataStructsAndAlgorithms.TestBinaryTree();
			DataStructsAndAlgorithms.TestManagedTreeWithNoBinaryTreeClass();
			DataStructsAndAlgorithms.TestNTree();
			DataStructsAndAlgorithms.TestSet();
        }
        #endregion
        
        #region "(12) FILE SYSTEM IO CHAPTER TEST CODE"
        static void TestFileSystemIO()
        {
            PrintHeader("File System IO Chapter Tests");

			FileSystemIO.CreateCopyMoveDeleteFile();
			FileSystemIO.ManipulateFileAttribs();
			//FileSystemIO.RenameFile();
			FileSystemIO.DetermineFileExists();
			FileSystemIO.ChooseMethodOpenFileOrStream();
			FileSystemIO.RandomAccessPartOfFile();
			FileSystemIO.PlatformIndependentEOL();
            //FileSystemIO.CreateWriteReadFile();
			FileSystemIO.DetermineDirectoryExists();
			FileSystemIO.CreateMoveDeleteDirectory();
			FileSystemIO.ManipulateDirectoryAttribs();
			FileSystemIO.RenameDirectory();
			FileSystemIO.SearchDirFileWildcards();
			FileSystemIO.ObtainDirTree();
			FileSystemIO.ParsePath();
			FileSystemIO.ParsePathsEnvVars();
			FileSystemIO.VerifyPath();
			FileSystemIO.UseTempFile();
			FileSystemIO.OpenFileStreamWithFileHandle();
			FileSystemIO.WriteMultipleOutputFiles();
			FileSystemIO.LaunchInteractConsoleUtils();
			FileSystemIO.LockSubsectionsOfAFile();
			FileSystemIO.WatchFileSystemChanges();
            //FileSystemIO.WaitFileSystemAction();
			FileSystemIO.CompareVersionInfo();
			FileSystemIO.TestAllDriveInfo();
            //FileSystemIO.TestEncryptExistingFile();
			FileSystemIO.TestCompressNewFile();
        }
        #endregion
        
        #region "(13) REFLECTION CHAPTER TEST CODE"
        static void TestReflection()
        {
            PrintHeader("Reflection Chapter Tests");

			Reflection.ListImportedAssemblies();
			Reflection.ListExportedTypes();
			Reflection.FindOverriddenMethods();
			Reflection.FindMembersInAssembly();
			Reflection.FindMembersInInterface();
			Reflection.ObtainNestedTypes();
			Reflection.DisplayInheritanceHierarchy();
			Reflection.FindSubclasses();
			Reflection.FindSerializableTypes();
			Reflection.ControlAdditionsList();
			Reflection.FilterOutput();
			Reflection.DynamicInvocation();
			Reflection.TestObfuscate();
			Reflection.TestIsGeneric();
			Reflection.TestManifestResourceInfo();
			Reflection.TestGetLocalVars();
			Reflection.CreateMultiMap();
			Reflection.TestGetIL();
        }
        #endregion

		#region "(14) WEB CHAPTER TEST CODE"
        #endregion

		#region "(15) XML CHAPTER TEST CODE"
		static void TestXML()
		{
			PrintHeader("XML Chapter Tests");

            XML.AccessXml();
            XML.ReadXmlWeb();
            XML.QueryXml();
            XML.ValidateXml();
            XML.CreateXml();
            XML.DetectXmlChanges();
            XML.HandleInvalidChars();
            XML.TransformXml();
            XML.ProcessInvoice();
            XML.ReceiveInvoice();
            XML.TestContinualValidation();
            XML.TestExtendingTransformations();
            XML.TestBulkSchema();
            XML.TestXSLTParams();
		}
		#endregion

		#region "(16) NETWORKING CHAPTER TEST CODE"
		static void TestNetworking()
		{
			PrintHeader("Networking Chapter Tests");

            Networking.SimulatingFormExecution();
            Networking.DownloadingDataFromServer();
            Networking.TestPing();
            Networking.TestSendMail();
            Networking.TestNetInfo();
            Networking.TestSockets();
            Networking.GetInternetSettings();
            Networking.TestFTPDownload();
		}
		#endregion

		#region "(17) SECURITY CHAPTER TEST CODE"
        static void TestSecurity()
        {
            PrintHeader("Security Chapter Tests");
            Security.ControlAccess();
            Security.EncDecString();
            Security.EncDecFile();
            Security.CleanUpCrypto();
            Security.VerifyNonStringCorruption();
            Security.WrappingStringHash();
            Security.BetterRandomString();
            Security.SecurelyStoringData();
            Security.SafeAssert();
            Security.PreventMaliciousMods();
            Security.VerifyAssemblyPerms();
            Security.MinimizeAttackSurface();
            Security.TestSecureString();
            Security.TestUnicodeEncodingWithSecurity();
        }
        #endregion
        
        #region "(18) THREADING AND SYNCHRONIZATION CHAPTER TEST CODE"
        static void TestThreadingSync()
        {
            PrintHeader("Threading Chapter Tests");

            ThreadingSync.PerThreadStatic();
            ThreadingSync.ThreadSafeAccess();
            ThreadingSync.PollingAsyncDelegate();
            ThreadingSync.TimeoutAsyncDelegate();
            ThreadingSync.CompletionAsyncDelegate();
            ThreadingSync.WaitThreadPoolFinish();
            ThreadingSync.ConfigTimer();
            ThreadingSync.DeterminePoolQueue();
            ThreadingSync.PreventSilentTermination();
            ThreadingSync.StoreThreadDataPrivately();
            ThreadingSync.Halo2Session.Play();
            ThreadingSync.TestResetEvent();
            ThreadingSync.TestManualNamedEvent();
            ThreadingSync.TestAutoNamedEvent();
            ThreadingSync.TestInterlocked();
        }
        #endregion
        
        #region "(19) UNSAFE CODE CHAPTER TEST CODE"
        static void TestUnsafeCode()
        {
            PrintHeader("Unsafe Code Chapter Tests");

			UnsafeCode.ControlChangesPointers();
			UnsafeCode.ComparePointers();
			UnsafeCode.NavigatingArrays();
			UnsafeCode.ManipulatePointerFixedArray();
			UnsafeCode.RetPtrArrayElement();
			UnsafeCode.CreateUseArrayPtrs();
			UnsafeCode.CreateUseArrayPtrsUnknown();
			UnsafeCode.SwitchUnknownPtr();
			UnsafeCode.BreakupLargeNumBytes();
			UnsafeCode.CvtPtrs();

			UnsafeCode.TestComparePtrValues();
			UnsafeCode.TestConvertStringToCharPtr();
			UnsafeCode.TestEmbeddedFixedArray();
        }
        #endregion
        
		#region "(20) TOOLBOX CHAPTER TEST CODE"
		static void TestToolbox()
		{
            Toolbox.PreventBadShutdown(); // 20.1
            Toolbox.TestServiceManipulation(); // 20.2
            string searchAssm = "System.Data.dll";
            List<Process> processes = Toolbox.GetProcessesAssemblyIsLoadedIn(searchAssm); // 20.3
            foreach (Process p in processes)
            {
                Console.WriteLine("Found {0} in {1}",searchAssm, p.MainModule.ModuleName);
            }
            Toolbox.TestMessageQueue(); // 20.4
            Console.WriteLine(Toolbox.GetCurrentFrameworkPath()); // 20.5
            Toolbox.PrintGACRegisteredVersions("mscorlib"); //20.6
            Toolbox.PrintGACRegisteredVersions("System.Web.dll"); //20.6
            Console.WriteLine(Toolbox.GetWinDir()); //20.7
            Toolbox.RedirectOutput(); // 20.8
            Toolbox.RunCodeInNewAppDomain(); //20.9
            Console.WriteLine(Toolbox.GetOSAndServicePack()); //20.10
        }
		#endregion
		
		static void Main(string[] args)
        {
            try
            {
                // Call test code here...
                TestNumbersAndEnums();
                //TestStringsAndChars();
                TestClassesAndStructs();
                TestGenerics();
                TestCollections();
                TestIteratorsPartialClasses();
                TestExceptionHandling();
                try
                {
                    TestDiagnostics();
                }
                catch (ObjectDisposedException e)
                {
                    Console.WriteLine(e);
                }
                TestDelegatesEventsAnonMeth();
                TestRegularExpressions();
                TestDataStructsAndAlgorithms();
                TestFileSystemIO();
                TestReflection();
                TestXML();
                TestNetworking();
                TestSecurity();
                TestThreadingSync();
                TestUnsafeCode();
                TestToolbox();
            }
            catch(Exception e)
            {
               Console.WriteLine(e.ToString());
            }

            // wait for enter to be pressed
            Console.WriteLine("Press ENTER to finish...");
            Console.ReadLine();
        }


        #region UtilityCode
        static void PrintHeader(string testtype)
        {
            Console.WriteLine("************************************************************");
            Console.WriteLine("**    Running " + testtype + "...");
            Console.WriteLine("************************************************************");
        }
        #endregion
    }
}
